// license:GPL_2.0
// copyright-holders:Robbbert
/* These sets were dumped with the Mega Game Doctor 2
   They are reputed to be bad dumps although I have not observed any problems.

   Due to the dumping process, the P roms have the 2 halves swapped around,
   and the C roms are split 32-byte-wise.

   Each rom is named thus: nxxx001z.vvv, where:
        xxx = the neogeo game number
        z = a/b/c/d, indicates the loading order
        vvv = 038 (P rom), 378 or 3f8 (S rom), 478 or 4f8 (M rom), 178, 1f8 (V rom, region 1),
        278, 2f8 (V rom, region 2), 538, 638, 53c, 63c (C rom)

   if more than 2 V roms (or 4 C roms) are used, then z increases by a letter.

   These games run the same as the usual MAME ones, except for alpham2 which has extra sound
   roms. This produces extra sounds, such as the ticking sound as soon as the game starts. */

#include "includes/neogeo.h"

ROM_START( 2020bbd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n030001a.038", 0x000001, 0x040000, CRC(efb016a2) SHA1(6bac3f89124e9af5c04e7e5b110e467a4ed85771) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "030.s1", CRC(7015b8fc) SHA1(8c09bc3e6c62e0f7c9557c1e10c901be325bae7f) ) // n030001a.378

	NEO_BIOS_AUDIO_128K( "n030001a.4f8", CRC(bf755068) SHA1(7f624a691f7e51481949462141778da3e1eb0b91) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n030001a.1f8", 0x000000, 0x080000, CRC(33e7886e) SHA1(78bd48fea1e2b1595661c8b957fe489c11e50b92) )
	ROM_LOAD( "n030001a.1fc", 0x080000, 0x080000, CRC(e7ca3882) SHA1(40fb282ad0560d5933badd03da927d395d2a70b5) )
	ROM_LOAD( "n030001b.1f8", 0x100000, 0x080000, CRC(3cf9a433) SHA1(3065079247f1f4a44452a9bb84c9a969fbd3773b) )
	ROM_LOAD( "n030001b.1fc", 0x180000, 0x080000, CRC(88b10192) SHA1(ef486cc57a9cba6c4382b9fd8839e3beb57e916d) )

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n030001a.538", 0x000000, 0x40000, CRC(746bf48a) SHA1(93006169cb4e26bf72372c5354e60f814f39df3a) )
	ROM_CONTINUE( 0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n030001a.638", 0x000001, 0x40000, CRC(5c123d9c) SHA1(98ce390641ad11823db5de779e01bf06c2eabb8a) )
	ROM_CONTINUE( 0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n030001a.53c", 0x100000, 0x40000, CRC(57bdcec0) SHA1(6a0cfc50386dff079be93a9ee96722ea1b3df9fc) )
	ROM_CONTINUE( 0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n030001a.63c", 0x100001, 0x40000, CRC(2f4bb615) SHA1(5cfda589291579edbabfc84894e1b9a8875588f2) )
	ROM_CONTINUE( 0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n030001b.538", 0x200000, 0x40000, CRC(0b054a38) SHA1(4a917b0dcbe4b270eadc4b99532d6912b3d3117f) )
	ROM_CONTINUE( 0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n030001b.638", 0x200001, 0x40000, CRC(b2a86447) SHA1(d7048c283853cbe52ef6733aed1f9a3bf22d70ec) )
	ROM_CONTINUE( 0x200003, 0x40000 )
ROM_END

ROM_START( 3countbd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n043001a.038", 0x000001, 0x040000, CRC(10dbe66a) SHA1(b3a50100f0d41f2cc9ad92687aaba52340b6d67d) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n043001a.03c", 0x080001, 0x040000, CRC(6d5bfb61) SHA1(8ba73917d8c29a5400fcc3b58e0cbbd100dd3182) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "043.s1", CRC(c362d484) SHA1(a3c029292572842feabe9aa8c3372628fb63978d) ) // n043001a.378

	NEO_BIOS_AUDIO_128K( "n043001a.4f8", CRC(3377cda3) SHA1(5712cd0717585914120ebf307391e1e3171f5396) )

	ROM_REGION( 0x400000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n043001a.1f8", 0x000000, 0x080000, CRC(2abe6ab0) SHA1(9d717d52889c9af76fc6790a0e97c54eabd3b931) )
	ROM_LOAD( "n043001a.1fc", 0x080000, 0x080000, CRC(d3fa2743) SHA1(9f065d708cad0b98e7b7b4c4e96a2a4f8da76e7e) )
	ROM_LOAD( "n043001b.1f8", 0x100000, 0x080000, CRC(f591b0a1) SHA1(68bcac77543eca84232f1628a32828cc9c4081bb) )
	ROM_LOAD( "n043001b.1fc", 0x180000, 0x080000, CRC(01f3999e) SHA1(4f9ec67e52aabe6a0d2e2210824349e25dd9269d) )
	ROM_LOAD( "n043001c.1f8", 0x200000, 0x080000, CRC(f76aa00e) SHA1(6dbde96b083c34ee77ce512edaa2284061172df5) )
	ROM_LOAD( "n043001c.1fc", 0x280000, 0x080000, CRC(851ce851) SHA1(58d2c904224c50cd9c2b5c5710bb8539b94af604) )
	ROM_LOAD( "n043001d.1f8", 0x300000, 0x080000, CRC(9e2c8366) SHA1(89ababf09a578750fed508475bcfb562bc9116a6) )
	ROM_LOAD( "n043001d.1fc", 0x380000, 0x080000, CRC(b1a0ccb0) SHA1(ccadb887818477906071edf85408bfe5d74e919a) )

	ROM_REGION( 0x800000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n043001a.538", 0x000000, 0x40000, CRC(be0d2fe0) SHA1(6c59673b5b7c362596374f45b0fc739e5608d4d2) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n043001a.638", 0x000001, 0x40000, CRC(f56dafa5) SHA1(2b9b1a1ed0a00b1bf3c7e490ac0995836c263dba) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n043001a.53c", 0x100000, 0x40000, CRC(fdb4df65) SHA1(ac59c3aaa5f794a21942015a41c3daa6a94d564c) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n043001a.63c", 0x100001, 0x40000, CRC(f2f68b2a) SHA1(3cd321ee4699be888a4c380a3202a2c4932cc240) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n043001b.538", 0x200000, 0x40000, CRC(714c2c01) SHA1(2a5e612807a6000824cc0ae848774c5e5bdcb572) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n043001b.638", 0x200001, 0x40000, CRC(b15a7f25) SHA1(c5488becc87fe5be5a402f5358cd4c6c7e7e0474) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n043001b.53c", 0x300000, 0x40000, CRC(c57ce8b0) SHA1(241d98fdf2cfb33321387c396b98011744b472c4) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n043001b.63c", 0x300001, 0x40000, CRC(25f00cd3) SHA1(55f51d80efab87ea1ea2bdcb92b97eeab3097b93) )
	ROM_CONTINUE(             0x300003, 0x40000 )
	ROM_LOAD32_BYTE( "n043001c.538", 0x400000, 0x40000, CRC(2e7e59df) SHA1(a0a5afd8259eff487d80a43405b6368bfb8a7862) )
	ROM_CONTINUE(             0x400002, 0x40000 )
	ROM_LOAD32_BYTE( "n043001c.638", 0x400001, 0x40000, CRC(341438e4) SHA1(233703b8ecd61ba173bf6636677f4f8e8972e8f4) )
	ROM_CONTINUE(             0x400003, 0x40000 )
	ROM_LOAD32_BYTE( "n043001c.53c", 0x500000, 0x40000, CRC(a93185ce) SHA1(8b979391f3dba5ee4869bbe8417cbe04f781a3bd) )
	ROM_CONTINUE(             0x500002, 0x40000 )
	ROM_LOAD32_BYTE( "n043001c.63c", 0x500001, 0x40000, CRC(fb8adce8) SHA1(e7a269db6b1f03cab4535b41caaae27e7d98dd4b) )
	ROM_CONTINUE(             0x500003, 0x40000 )
	ROM_LOAD32_BYTE( "n043001d.538", 0x600000, 0x40000, CRC(410938c5) SHA1(230e4c466a38fee7432be7352b99b9331c227532) )
	ROM_CONTINUE(             0x600002, 0x40000 )
	ROM_LOAD32_BYTE( "n043001d.638", 0x600001, 0x40000, CRC(74d995c5) SHA1(fd269844104c598cda96cc8823c0acdbddeaa9ba) )
	ROM_CONTINUE(             0x600003, 0x40000 )
	ROM_LOAD32_BYTE( "n043001d.53c", 0x700000, 0x40000, CRC(50d66909) SHA1(4458e59e7fdddd8c2383d4f0edd025a08eaa1222) )
	ROM_CONTINUE(             0x700002, 0x40000 )
	ROM_LOAD32_BYTE( "n043001d.63c", 0x700001, 0x40000, CRC(521b6df1) SHA1(aa8a072f1abe4a0bb62a917dd2662dfdbaef0faa) )
	ROM_CONTINUE(             0x700003, 0x40000 )
ROM_END

ROM_START( alpham2d )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n007001a.038", 0x000001, 0x040000, CRC(4400b34c) SHA1(99cd25c0383e8ffba2d83f2d9c5c6452fe69c362) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n007001a.03c", 0x080001, 0x040000, CRC(b0366875) SHA1(591a02a5cef01e190eaed922894920571f4f6bdb) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "007.s1", CRC(85ec9acf) SHA1(39a11974438ad36a2cc84307151b31474c3c5518) ) // n007001a.378

	NEO_BIOS_AUDIO_64K( "n007001a.478", CRC(0449acf5) SHA1(1275ba5dad1c5123f727dd4193b8ee2cb910760d) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n007001a.178", 0x000000, 0x080000, CRC(7ec0e76d) SHA1(5f84f0a236b5cb7dd02b588806bc7f6e35eb515d) )
	ROM_LOAD( "n007001a.17c", 0x080000, 0x080000, CRC(7a796ead) SHA1(0a5b2683acc680edef3d3aa44681e0d648dce53f) )
	ROM_LOAD( "n007001b.178", 0x100000, 0x080000, CRC(70bc86a5) SHA1(00ef9faf9b094bca2fd654b26eb03e6e40bd6f80) )
	ROM_LOAD( "n007001b.17c", 0x180000, 0x080000, CRC(29963a92) SHA1(fb2ff29e48cfee33c0f8c12f849b35bd5be27ec9) )

	ROM_REGION( 0x400000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "n007001a.278", 0x000000, 0x080000, CRC(45f5e914) SHA1(d89d9917a0aaf1c662d5633a52a29bd670577830) )
	ROM_LOAD( "n007001a.27c", 0x080000, 0x080000, CRC(07524063) SHA1(559c3f1b33cfb112dd8d70726be07cac1cafd72f) )
	ROM_LOAD( "n007001b.278", 0x100000, 0x080000, CRC(c3178623) SHA1(687e63943a22cfff9778cb41ef6c9b9ac6f43334) )
	ROM_LOAD( "n007001b.27c", 0x180000, 0x080000, CRC(65bca6b7) SHA1(8c96d98e86799f1a47b5a66d439e01d7935c213c) )
	ROM_LOAD( "n007001c.278", 0x200000, 0x080000, CRC(27cd2250) SHA1(ab5af5762f48f670b2d0a31fdd38539956681035) )
	ROM_LOAD( "n007001c.27c", 0x280000, 0x080000, CRC(43025293) SHA1(c8b612f4bead98d6e06dcf6cb8254fc8487e2c06) )
	ROM_LOAD( "n007001d.278", 0x300000, 0x080000, CRC(ae0a679a) SHA1(7fd81af67238eae3dba64502eeff41933de795e8) )
	ROM_LOAD( "n007001d.27c", 0x380000, 0x080000, CRC(6a2e400d) SHA1(656b026767596a6395f3e30f97140884cb0da5a0) )

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n007001a.538", 0x000000, 0x40000, CRC(c516b09e) SHA1(910b6197fef78138da2c5b18507d12d841a518e5) )
	ROM_CONTINUE( 0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n007001a.638", 0x000001, 0x40000, CRC(6b674581) SHA1(3cbf29302c2677abe79ae10ef95097c6d62ca88c) )
	ROM_CONTINUE( 0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n007001a.53c", 0x100000, 0x40000, CRC(d9a0ff6c) SHA1(f2577736d516471a6757a8134916fbf7316a9809) )
	ROM_CONTINUE( 0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n007001a.63c", 0x100001, 0x40000, CRC(4ff21008) SHA1(496a27d902342dbb3685ad8354981e76dc839f47) )
	ROM_CONTINUE( 0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n007001b.538", 0x200000, 0x40000, CRC(3a7fe4fd) SHA1(ad4d93ed7d472579b6ba5fd4809a96762f0c0c2e) )
	ROM_CONTINUE( 0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n007001b.638", 0x200001, 0x40000, CRC(d0e8eef3) SHA1(560594bf1ec6ca32b38d0fe73b4cb5b5ecb56d56) )
	ROM_CONTINUE( 0x200003, 0x40000 )
ROM_END

ROM_START( androdund )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n049001a.038", 0x000001, 0x040000, CRC(4639b419) SHA1(617765aea2cb26ae52b25b2f7a541caf14effac9) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n049001a.03c", 0x080001, 0x040000, CRC(11beb098) SHA1(8c8fafba019e94fcf56643fbeeae161840e4263d) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "049.s1", CRC(6349de5d) SHA1(bcc44b9576d7bedd9a39294530bb66f707690c72) ) // n049001a.378

	NEO_BIOS_AUDIO_128K( "n049001a.4f8", CRC(1a009f8c) SHA1(7782dfe48e143417f34fba5353e6deb63efeaa8a) )

	ROM_REGION( 0x100000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n049001a.1f8", 0x000000, 0x080000, CRC(577c85b3) SHA1(2c3072401fe73497dca0e9009ae2ba4053fe936d) )
	ROM_LOAD( "n049001a.1fc", 0x080000, 0x080000, CRC(e14551c4) SHA1(763a9912b9df55defb190af3f29ae034f6dd78d6) )

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n049001a.538", 0x000000, 0x40000, CRC(ca08e432) SHA1(4202685ea0eaa29772d3d451ed9240202e4626a4) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n049001a.638", 0x000001, 0x40000, CRC(7a0deb9e) SHA1(50953e69b8462d4b981c91c74c307bcb539b0ceb) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n049001a.53c", 0x100000, 0x40000, CRC(fcbcb305) SHA1(42fe48127593e7714f7675506de8d0ae08a70164) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n049001a.63c", 0x100001, 0x40000, CRC(b1c640f5) SHA1(6e667f4c197243f6389c952229efa90bd3a66b50) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n049001b.538", 0x200000, 0x40000, CRC(806ab937) SHA1(78867c587420b938be1a76f0b87dea4d21fbe1b0) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n049001b.638", 0x200001, 0x40000, CRC(33bee10f) SHA1(3e01859e6455c9e941f9afcf31d62a4de4806eca) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n049001b.53c", 0x300000, 0x40000, CRC(e7e1a2be) SHA1(91a68ed46975811f1abaf4d1d912f514328c7189) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n049001b.63c", 0x300001, 0x40000, CRC(70f0d263) SHA1(fccb548d4b1754c475ceb46f3e49e4e9607e6651) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( aofd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n044001a.038", 0x000001, 0x040000, CRC(95102254) SHA1(b4b9a0b35c2fab78fa9fd590f0f22da4e4153ac2) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "044.s1", CRC(89903f39) SHA1(a04a0c244a5d5c7a595fcf649107969635a6a8b6) ) // n044001a.378

	NEO_BIOS_AUDIO_128K( "044001a.4f8", CRC(981345f8) SHA1(5eb6a5a3f633d74a48555808e2562a0ba16d8675) )

	ROM_REGION( 0x400000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n044001a.1f8", 0x000000, 0x080000, CRC(a4d8747f) SHA1(d9963375edd22d194c17e50fa398b12bbe2a777f) )
	ROM_LOAD( "n044001a.1fc", 0x080000, 0x080000, CRC(55219d13) SHA1(97fa9b1461e9dbf6c1580e1f814df68c79b61016) )
	ROM_LOAD( "n044001b.1f8", 0x100000, 0x080000, CRC(6eae81fa) SHA1(37d5ea320913b77a3fcdd2e1db1447a9cd77d094) )
	ROM_LOAD( "n044001b.1fc", 0x180000, 0x080000, CRC(f91676e9) SHA1(5c3e8f4230a2b18af8cea4ee32c23408de575c0c) )
	ROM_LOAD( "n044001c.1f8", 0x200000, 0x080000, CRC(d0c8bcd2) SHA1(126d56214a51027a340153b0dc29268ef7d36256) )
	ROM_LOAD( "n044001c.1fc", 0x280000, 0x080000, CRC(167db9b2) SHA1(960c32b4163d7cadba26d4f64627bce08d4da65b) )
	ROM_LOAD( "n044001d.1f8", 0x300000, 0x080000, CRC(f03969fe) SHA1(5e30c9162bdb8236ccd7ec1e99107da656764fe8) )
	ROM_LOAD( "n044001d.1fc", 0x380000, 0x080000, CRC(a823a19a) SHA1(5662874b80b9df94c60f7100eefa229e95bd91d5) )

	ROM_REGION( 0x800000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n044001a.538", 0x000000, 0x40000, CRC(a2e4a168) SHA1(7a0090f85235ae2a50498ab3538fef2f8afa7242) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n044001a.638", 0x000001, 0x40000, CRC(ca12c80f) SHA1(c7e4b241719f04860abf5fbb6e1712a802e43dee) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n044001a.53c", 0x100000, 0x40000, CRC(da389ef7) SHA1(b3c6ec60c5bdb63943a23eed028d9c952b11fc24) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n044001a.63c", 0x100001, 0x40000, CRC(d59746b0) SHA1(4d66e8384be5ce2917cf7db099000c229fb2d767) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n044001b.538", 0x200000, 0x40000, CRC(2a0c385b) SHA1(7d8e20a81e15f6806af43edb7d35e65052c32cbd) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n044001b.638", 0x200001, 0x40000, CRC(8b73b3da) SHA1(046e4a02f2c305ded91b22e09bf421d4f3d84f0c) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n044001b.53c", 0x300000, 0x40000, CRC(4a4317bf) SHA1(805405d440e4dba2cdc8b89629b0ab9616b5d357) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n044001b.63c", 0x300001, 0x40000, CRC(9fc3f8ea) SHA1(5a0520980b69724cdd011841844545dafc259ff9) )
	ROM_CONTINUE(             0x300003, 0x40000 )
	ROM_LOAD32_BYTE( "n044001c.538", 0x400000, 0x40000, CRC(471d9e57) SHA1(54200bd380f8f6b19f64768033b97a96aa8a8640) )
	ROM_CONTINUE(             0x400002, 0x40000 )
	ROM_LOAD32_BYTE( "n044001c.638", 0x400001, 0x40000, CRC(cbf8a72e) SHA1(182b7f98f414533f1ea294f3ea8b25e98857e0cd) )
	ROM_CONTINUE(             0x400003, 0x40000 )
	ROM_LOAD32_BYTE( "n044001c.53c", 0x500000, 0x40000, CRC(23fe5675) SHA1(a03b0739c3b98150a610aada2c945165a58a56d7) )
	ROM_CONTINUE(             0x500002, 0x40000 )
	ROM_LOAD32_BYTE( "n044001c.63c", 0x500001, 0x40000, CRC(5ec93c96) SHA1(6a5869fe778774ef1a641068e65e33a1ea2bd15b) )
	ROM_CONTINUE(             0x500003, 0x40000 )
	ROM_LOAD32_BYTE( "n044001d.538", 0x600000, 0x40000, CRC(204e7b29) SHA1(944865fb04e554f217dbaa2259834e1c413afe50) )
	ROM_CONTINUE(             0x600002, 0x40000 )
	ROM_LOAD32_BYTE( "n044001d.638", 0x600001, 0x40000, CRC(47763b6d) SHA1(b7e6cb423e3c49bca60ff190ff105001e3579701) )
	ROM_CONTINUE(             0x600003, 0x40000 )
	ROM_LOAD32_BYTE( "n044001d.53c", 0x700000, 0x40000, CRC(7f6d5144) SHA1(8f39666259d8fe187ae6da532372b6c606737246) )
	ROM_CONTINUE(             0x700002, 0x40000 )
	ROM_LOAD32_BYTE( "n044001d.63c", 0x700001, 0x40000, CRC(4408f4eb) SHA1(dc045494f6865def21448caab13b2ad6ee520f37) )
	ROM_CONTINUE(             0x700003, 0x40000 )
ROM_END

ROM_START( bakatonod )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n036001a.038", 0x000001, 0x040000, CRC(083ca651) SHA1(8d947e5de3db3a8cf4195de3b149d4a7994704c1) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n036001a.03c", 0x080001, 0x040000, CRC(b3bc26ae) SHA1(c0a741198627a78f7a100ee406d994b50e63012f) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "036.s1", CRC(f3ef4485) SHA1(c30bfceed7e669e4c97b0b3ec2e9f4271e5b6662) ) // n036001a.378

	NEO_BIOS_AUDIO_64K( "n036001a.4f8", CRC(a5e05789) SHA1(63985ed5b3491d0f7b0e2f59785f590bfe122330) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n036001a.1f8", 0x000000, 0x080000, CRC(d3edbde6) SHA1(c8628a47e275137e340f2005775272a58a594d81) )
	ROM_LOAD( "n036001a.1fc", 0x080000, 0x080000, CRC(cc487705) SHA1(3bc30dc485917a01756ed33b3507133549e3c1f8) )
	ROM_LOAD( "n036001b.1f8", 0x100000, 0x080000, CRC(e28cf9b3) SHA1(6c0bc9f5f496edb89dd8dc7acbec3c361bcef0f3) )
	ROM_LOAD( "n036001b.1fc", 0x180000, 0x080000, CRC(96c3ece9) SHA1(357ed280157897e26eeecce080da9757f1c03b35) )

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n036001a.538", 0x000000, 0x40000, CRC(acb82025) SHA1(6bc9b61fdbcb04a1acc0c692a066791bf412d814) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n036001a.638", 0x000001, 0x40000, CRC(647ba28f) SHA1(761884eabcf3be81614ee1d2cf6a86515b3fb628) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n036001a.53c", 0x100000, 0x40000, CRC(c6954f8e) SHA1(b7f09c1d5800ea82abee8f0b00d0c9395882fe00) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n036001a.63c", 0x100001, 0x40000, CRC(dffefa4f) SHA1(bdc9bd4d09808a51d8fb27c337f0382d5ddd58df) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n036001b.538", 0x200000, 0x40000, CRC(eb751be8) SHA1(50db6c2055160396f7a6e4ada9fa52a458046ad2) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n036001b.638", 0x200001, 0x40000, CRC(6135247a) SHA1(0c23a0894484689124873cfc37a4e0a05e226f2d) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n036001b.53c", 0x300000, 0x40000, CRC(1d39bad6) SHA1(8f275cc73844760725b476264db0543a1327fb21) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n036001b.63c", 0x300001, 0x40000, CRC(0d40c953) SHA1(f77d84cb6b9bfe580f69a319d4f4fd98389e6d49) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( bstarsd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n002001a.038", 0x000001, 0x040000, CRC(68ce5b06) SHA1(cab050a4efcf346463609910b367f7f6c1c0158b) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "002.s1", CRC(1a7fd0c6) SHA1(3fc701b7afddab369ddf9dedfbc5e1aaf80b8af3) ) // n002001a.378

	NEO_BIOS_AUDIO_64K( "n002001a.478", CRC(79a8f4c2) SHA1(08ca2b72fd9b0ed068dc918ecda51d13203a3481) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "002.v11", 0x000000, 0x080000, CRC(b7b925bd) SHA1(644c92fa90e74998e73714f74b1e0680ee372a07) ) // n002001a.178
	ROM_LOAD( "002.v12", 0x080000, 0x080000, CRC(329f26fc) SHA1(2c8009edc88c6b26f7be5beb2b8d260aac394ee1) ) // n002001a.17c
	ROM_LOAD( "002.v13", 0x100000, 0x080000, CRC(0c39f3c8) SHA1(db8f8670639601215707d918d4fb93221460446a) ) // n002001b.178
	ROM_LOAD( "002.v14", 0x180000, 0x080000, CRC(c7e11c38) SHA1(5abf2a7877e0162c758a4dcf09f183930fa7ef24) ) // n002001b.17c

	ROM_REGION( 0x080000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "002.v21", 0x000000, 0x080000, CRC(04a733d1) SHA1(84159368c0f6de2c3b8121227201cd3422455cf6) ) // n002001a.278

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n002001a.538", 0x000000, 0x40000, CRC(c55a7229) SHA1(23a28f8ba6c1339dde4f674bbca6e6cffafabcc7) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n002001a.638", 0x000001, 0x40000, CRC(cd3eeb2d) SHA1(3997788c063cea48a901ff6033574d2c8a9e0516) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n002001a.53c", 0x100000, 0x40000, CRC(a0074bd9) SHA1(f1b1ba3630befd595d141bfc580b1bbe01bee324) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n002001a.63c", 0x100001, 0x40000, CRC(d651fecf) SHA1(3e7bbda2ecd487e568f8e8eb9b141941d6a761b9) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n002001b.538", 0x200000, 0x40000, CRC(d57767e6) SHA1(cf18dd9cf6f9da09af7be5e0c9f7f12eaa61c129) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n002001b.638", 0x200001, 0x40000, CRC(5d0a8692) SHA1(1a0f767d11f73fd41aa2f1840fc300fb23b8d262) )
	ROM_CONTINUE(             0x200003, 0x40000 )
ROM_END

ROM_START( burningfd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n018001a.038", 0x000001, 0x040000, CRC(188c5e11) SHA1(0f82b0e6fd93f43579f7cb2871e6840c738696af) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "018.s1", CRC(6799ea0d) SHA1(ec75ef9dfdcb0b123574fc6d81ebaaadfba32fb5) ) // n018001a.378

	NEO_BIOS_AUDIO_128K( "n018001a.4f8", CRC(58d10c2b) SHA1(5f1f01af284f6520d09ae1c5f6f176153a013f90) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n018001a.1f8", 0x000000, 0x080000, CRC(b55b9670) SHA1(b0ff38b2dca1361ad155e90be3674dbea1c0a53c) )
	ROM_LOAD( "n018001a.1fc", 0x080000, 0x080000, CRC(a0bcf260) SHA1(5d1f2613cf4a292557f37e6f44a90b20d11ed8cd) )
	ROM_LOAD( "n018001b.1f8", 0x100000, 0x080000, CRC(270f4707) SHA1(29e763acc9fd4b94d8b5d0ad917e20d8a66bbe49) )
	ROM_LOAD( "n018001b.1fc", 0x180000, 0x080000, CRC(924e3d69) SHA1(927091f9a098f00eb303f5567f4ee926bcb170e3) )

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n018001a.538", 0x000000, 0x40000, CRC(4ddc137b) SHA1(02add8810ed4df43feda93dd61c308bf1752e1dc) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n018001a.638", 0x000001, 0x40000, CRC(7d7d87dc) SHA1(efd24a8b6112c38e7d4bca46dfae227a80883be7) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n018001a.53c", 0x100000, 0x40000, CRC(896d8545) SHA1(415e5982275d43666d5b33c1a599e5fe073e0ab1) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n018001a.63c", 0x100001, 0x40000, CRC(39fe5307) SHA1(6be6306324ff63715e5ddb33c9565a538472e014) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n018001b.538", 0x200000, 0x40000, CRC(2b2cb196) SHA1(2826b07d72adb0c83cd84dbfc3d9a6eae93bd3b7) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n018001b.638", 0x200001, 0x40000, CRC(03aa8a36) SHA1(e68f12e869b0c947a0b2a0dd591edbe995e95775) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n018001b.53c", 0x300000, 0x40000, CRC(0f49caa9) SHA1(5a86c3b2a29b1bee10a2649c0106e0a4948f5ecf) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n018001b.63c", 0x300001, 0x40000, CRC(f759626e) SHA1(29e123c8d40334a53fceae33308d92a0dd3ac80d) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( crswordd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n037001a.038", 0x000001, 0x040000, CRC(42c78fe1) SHA1(4e680092f87baa8ce1ec375bedfd393b553bad11) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "037.s1", CRC(74651f27) SHA1(bff7ff2429d2be82c1647abac2ee45b339b3b310) ) // n037001a.378

	NEO_BIOS_AUDIO_64K( "n037001a.4f8", CRC(66633e5e) SHA1(24611f084643c36069c2e48dac86413a18f9663b) )

	ROM_REGION( 0x100000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n037001a.1f8", 0x000000, 0x080000, CRC(525df5c8) SHA1(de8802aa515de5b552df87ba4eb3aa27c12105c9) )
	ROM_LOAD( "n037001a.1fc", 0x080000, 0x080000, CRC(a11ecaf4) SHA1(214ef018628a6acf2464fdd98afadb02e4f609eb) )

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n037001a.538", 0x000000, 0x40000, CRC(4b373de7) SHA1(4a3cd07cb2b029c28bdea9918d839fa308324921) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n037001a.638", 0x000001, 0x40000, CRC(e05f5f33) SHA1(af11079524edf2db79efd8ab25b33689a0d1080b) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n037001a.53c", 0x100000, 0x40000, CRC(cddf6d69) SHA1(04f002d6648af24ca5c887bcd8b73d3a59becd2c) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n037001a.63c", 0x100001, 0x40000, CRC(91ab11a4) SHA1(b063bf2ab89382014159fbe5372a0893782fa510) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n037001b.538", 0x200000, 0x40000, CRC(61d25cb3) SHA1(fde39e2a3cc920772981afb6843f69c6b7b55f2d) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n037001b.638", 0x200001, 0x40000, CRC(01357559) SHA1(898db3366147e4c8920de9efb52b9d852dded010) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n037001b.53c", 0x300000, 0x40000, CRC(00bc3d84) SHA1(9eab28250902748563bc6a0dc4bd0ea66126a767) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n037001b.63c", 0x300001, 0x40000, CRC(28c6d19a) SHA1(96aa762ec26a6b954ec7414b74febf6b88e272aa) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( cyberlipd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n010001a.038", 0x000001, 0x040000, CRC(4012e465) SHA1(81caac2b559183f5a87980b6f1ca7e42d5338962) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n010001a.03c", 0x080001, 0x040000, CRC(ee899b19) SHA1(3d0369ad2496e8622fb5a11f751056a2c5fad7bf) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "010.s1", CRC(79a35264) SHA1(c2819a82adbe1f5e489496e0e03477863a5b7665) ) // n010001a.378

	NEO_BIOS_AUDIO_128K( "010.m1", CRC(8be3a078) SHA1(054ec6a061fcc88df1ecbb0a01611a31f37a7709) ) // n010001a.478

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "010.v11", 0x000000, 0x080000, CRC(90224d22) SHA1(5443ee6f90d80d43194cb4b4f0e08851a59e7784) ) // n010001a.178
	ROM_LOAD( "010.v12", 0x080000, 0x080000, CRC(a0cf1834) SHA1(8df57a7941bdae7e446a6056039adb012cdde246) ) // n010001a.17c
	ROM_LOAD( "010.v13", 0x100000, 0x080000, CRC(ae38bc84) SHA1(c0937b4f89b8b26c8a0e747b234f44ad6a3bf2ba) ) // n010001b.178
	ROM_LOAD( "010.v14", 0x180000, 0x080000, CRC(70899bd2) SHA1(8cf01144f0bcf59f09777175ae6b71846b09f3a1) ) // n010001b.17c

	ROM_REGION( 0x080000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "010.v21", 0x000000, 0x080000, CRC(586f4cb2) SHA1(588460031d84c308e3353ecf714db9986425c21c) ) // n010001a.278

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n010001a.538", 0x000000, 0x40000, CRC(0239fc08) SHA1(27c2a68103ca6898780d72ded57f4447cf5f7f80) )
	ROM_CONTINUE( 0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n010001a.638", 0x000001, 0x40000, CRC(e102a1bd) SHA1(89ffd05845b452423b4cd69c4420eafa0c168507) )
	ROM_CONTINUE( 0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n010001a.53c", 0x100000, 0x40000, CRC(23f03b97) SHA1(f5a2b3c0cf039a84cf78223f089f9fa3a7d9f01a) )
	ROM_CONTINUE( 0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n010001a.63c", 0x100001, 0x40000, CRC(520571d2) SHA1(4be129b679d3962a95ce32f462c58aa08c43b1cd) )
	ROM_CONTINUE( 0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n010001b.538", 0x200000, 0x40000, CRC(065061ed) SHA1(5c1e48e31cc6b5bbc50085abc8102ab436885b23) )
	ROM_CONTINUE( 0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n010001b.638", 0x200001, 0x40000, CRC(2e31e2d2) SHA1(29c88296d10b6b716ab753d2692267e0619d6193) )
	ROM_CONTINUE( 0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n010001b.53c", 0x300000, 0x40000, CRC(e485e72d) SHA1(1fb160f403b6ec1ff28408d141dfe31245dbfb58) )
	ROM_CONTINUE( 0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n010001b.63c", 0x300001, 0x40000, CRC(9e2af4db) SHA1(0089d1a66fa40a25ea78c6da24b4872b4fd12782) )
	ROM_CONTINUE( 0x300003, 0x40000 )
ROM_END

ROM_START( eightmand )
	ROM_REGION(0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n025001a.038", 0x000001, 0x040000, CRC(e23e2631) SHA1(ddc9efe6e386aa89aca052f004492caf39a84d68) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "025.s1", CRC(a402202b) SHA1(75c44e1af459af155f5b892fd18706268dd5e602) ) // n025001a.378

	NEO_BIOS_AUDIO_128K( "n025001a.4f8", CRC(68b6e0ef) SHA1(8a6c221460454d15c3d72dd66a2318be0a3d5072) )

	ROM_REGION(0x200000, "ymsnd:adpcma", 0)
	ROM_LOAD( "n025001a.1f8", 0x000000, 0x080000, CRC(0a2299b4) SHA1(96087ec57bca13a7394566c87310cd5a05eae62a) )
	ROM_LOAD( "n025001a.1fc", 0x080000, 0x080000, CRC(b695e254) SHA1(ca752c4834dcdd8c2829e336abf135e584ade603) )
	ROM_LOAD( "n025001b.1f8", 0x100000, 0x080000, CRC(6c3c3fec) SHA1(69f7cb9a4c39b651898383ec9ee6891565e93baf) )
	ROM_LOAD( "n025001b.1fc", 0x180000, 0x080000, CRC(375764df) SHA1(7288befc006bd10030911efecfbf78146ed5f781) )

	ROM_REGION(0x300000, "sprites", 0)
	ROM_LOAD32_BYTE( "n025001a.538", 0x000000, 0x40000, CRC(c916c9bf) SHA1(ac56aa28b163d21af80f355011112c1921a6797b) )
	ROM_CONTINUE( 0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n025001a.638", 0x000001, 0x40000, CRC(7114bce3) SHA1(a74abb92ec513250abea7487fd49ec2282a6531f) )
	ROM_CONTINUE( 0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n025001a.53c", 0x100000, 0x40000, CRC(4b057b13) SHA1(1d06edc938d8c618847853ae58de9a6e8dd6521f) )
	ROM_CONTINUE( 0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n025001a.63c", 0x100001, 0x40000, CRC(51da9a34) SHA1(850275621db0372839db334161c167c0df0915ac) )
	ROM_CONTINUE( 0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n025001b.538", 0x200000, 0x40000, CRC(12d53af0) SHA1(69bc5c1f6aa4386e851d2d0db04b5a9246257a90) )
	ROM_CONTINUE( 0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n025001b.638", 0x200001, 0x40000, CRC(43cf58f9) SHA1(72b4f27b66d45155aa98d65457c4fdd3b09d08e9) )
	ROM_CONTINUE( 0x200003, 0x40000 )
ROM_END

ROM_START( fatfury1d )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n033001a.038", 0x000001, 0x040000, CRC(47e51379) SHA1(bb1558765f55e0b8e3e0c1c5c79db8cec8b51085) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n033001a.03c", 0x080001, 0x040000, CRC(19d36805) SHA1(6b2d5326a08b06a9152d80a8de054ad9f159a453) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "033.s1", CRC(3c3bdf8c) SHA1(2f3e5feed6c27850b2a0f6fae0b97041690e944c) ) // n033001a.378

	NEO_BIOS_AUDIO_128K( "n033001a.4f8", CRC(a8603979) SHA1(512f2280a43892d4ca003ac63945ce86c5211b97) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n033001a.1f8", 0x000000, 0x080000, CRC(86fabf00) SHA1(df087f58c689128f7696b91e2fcb600ccac017af) )
	ROM_LOAD( "n033001a.1fc", 0x080000, 0x080000, CRC(ead1467b) SHA1(6f4381d7a0625f5d02739a9813ff593c2dc99dde) )
	ROM_LOAD( "n033001b.1f8", 0x100000, 0x080000, CRC(fc3bd6f7) SHA1(8d3094ecd8d5cfe3f58be9ac6d76a2bb65eb1d00) )
	ROM_LOAD( "n033001b.1fc", 0x180000, 0x080000, CRC(d312f6c0) SHA1(3fae32af628ed8d0176a7f6668ff4f2d898c9f7a) )

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n033001a.538", 0x000000, 0x40000, CRC(9aaa6d73) SHA1(345ed4b75a6459cd0b8fc8f71d58f4951296177f) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n033001a.638", 0x000001, 0x40000, CRC(9cae3703) SHA1(1144ccf448ea7c00ca425fe54f2ce84b8fdb3c78) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n033001a.53c", 0x100000, 0x40000, CRC(a986f4a9) SHA1(a45cc6b5902333d6614b7a2018ebd5ada7c5f075) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n033001a.63c", 0x100001, 0x40000, CRC(308b619f) SHA1(384efb66633a888d7c48d2ab0e918d823178b382) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n033001b.538", 0x200000, 0x40000, CRC(7aefe57d) SHA1(ab97881ff620ab7130d9ce1527c23bcfc0b21a5e) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n033001b.638", 0x200001, 0x40000, CRC(b39a0cde) SHA1(e5829525bc2ffe489ebb0ec4ab0094417f141027) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n033001b.53c", 0x300000, 0x40000, CRC(e3057c96) SHA1(b6a2e55633db0aad7f1ca4e8b42c2a327f772add) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n033001b.63c", 0x300001, 0x40000, CRC(737bc030) SHA1(03ceeabb84dac6f27c6f6ba2b7097b756f411270) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( fbfrenzyd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n034001a.038", 0x000001, 0x040000, CRC(c9fc879c) SHA1(24b8be60a434c3f4944f060607756a830f9365fd) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "034.s1", CRC(8472ed44) CRC(8472ed44) SHA1(42e1a9671dddd090d2a634cff986f6c73ba08b70) ) // n034001a.378

	NEO_BIOS_AUDIO_128K( "n034001a.4f8", CRC(079a203c) SHA1(b0e818400c46331ec42f9bb8fa3feacb6c69006a) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n034001a.1f8", 0x000000, 0x080000, CRC(d295da77) SHA1(3015a07236714af87928a9bff1a9505a9ee9b419) )
	ROM_LOAD( "n034001a.1fc", 0x080000, 0x080000, CRC(249b7f52) SHA1(4aa1e7f73c37ecdd09098a3943c8ff3e919788be) )
	ROM_LOAD( "n034001b.1f8", 0x100000, 0x080000, CRC(e438fb9d) SHA1(0403345549e618a3161c74a37ecae894b6e8d1e0) )
	ROM_LOAD( "n034001b.1fc", 0x180000, 0x080000, CRC(4f9bc109) SHA1(05f47d9b7de8a4f51fce43c14a2f5e7d616058a3) )

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n034001a.538", 0x000000, 0x40000, CRC(cd377680) SHA1(0ba533dc644b4111361e6f0ef31b2a92bc974efb) )
	ROM_CONTINUE( 0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n034001a.638", 0x000001, 0x40000, CRC(8b76358f) SHA1(ba908221daa9bfe7eaf03e370329fdb4a015da5f) )
	ROM_CONTINUE( 0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n034001a.53c", 0x100000, 0x40000, CRC(2f6d09c2) SHA1(5afffa37d5782c21e0d673ebfaf03f92fb5b91e4) )
	ROM_CONTINUE( 0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n034001a.63c", 0x100001, 0x40000, CRC(77e45dd2) SHA1(a4412ddfde175405c85eba2e56eec3d9878575d3) )
	ROM_CONTINUE( 0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n034001b.538", 0x200000, 0x40000, CRC(9abe41c8) SHA1(ab350c65258e5d229ab317d45580ae4cbbcd1478) )
	ROM_CONTINUE( 0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n034001b.638", 0x200001, 0x40000, CRC(336540a8) SHA1(7be473063680987560a188e59f477c8ff9b96b01) )
	ROM_CONTINUE( 0x200003, 0x40000 )
ROM_END

ROM_START( gpilotsd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n020001a.038", 0x000001, 0x040000, CRC(fc5837c0) SHA1(1eb46c21b17130238a1453c219e006ea150370ee) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n020001a.03c", 0x080001, 0x040000, CRC(47a641da) SHA1(d369ee64fd70d705355df71766b72c402a236e24) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "020.s1", CRC(a6d83d53) SHA1(9a8c092f89521cc0b27a385aa72e29cbaca926c5) ) // n020001a.378

	NEO_BIOS_AUDIO_64K( "n020001a.478", CRC(fc05fb8b) SHA1(bab6e6af4a60ffebff25951eca4177ece68875a4) )

	ROM_REGION( 0x180000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n020001a.178", 0x000000, 0x080000, CRC(8cc44140) SHA1(0a88d8962e057bf0cabd4819d4ba67e093c49b82) )
	ROM_LOAD( "n020001a.17c", 0x080000, 0x080000, CRC(415c61cd) SHA1(638e5fd9b02b4553df42f00188a7ac52a5a7bf84) )
	ROM_LOAD( "020.v12",  0x100000, 0x080000, CRC(4a9e6f03) SHA1(d3ac11f333b03d8a318921bdaefb14598e289a14) ) // n020001b.178

	ROM_REGION( 0x080000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "020.v21", 0x000000, 0x080000, CRC(7abf113d) SHA1(5b2a0e70f2eaf4638b44702dacd4cb17838fb1d5) ) // n020001a.278

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n020001a.538", 0x000000, 0x40000, CRC(92b8ee5f) SHA1(ff45ca2eed87863f3725d5dadd5f55ac39af033e) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n020001a.638", 0x000001, 0x40000, CRC(05733639) SHA1(a5f2639853ea53ec3ff91fe37fdb9e628a497883) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n020001a.53c", 0x100000, 0x40000, CRC(8c8e42e9) SHA1(9aa2abd11358933d72dc52ae8d0214e3b350c83b) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n020001a.63c", 0x100001, 0x40000, CRC(347fef2b) SHA1(8b4c7ab7d9cfda8e588d8e0f4796ce163b468407) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n020001b.538", 0x200000, 0x40000, CRC(4f12268b) SHA1(fa531734c9dbba62e35cb29eb40d80a219d87c54) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n020001b.638", 0x200001, 0x40000, CRC(2c586176) SHA1(0e28a27d59ae2ec6a9d1ff822244bfa4f960f338) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n020001b.53c", 0x300000, 0x40000, CRC(7c3c9c7e) SHA1(43a15669788384024ac173e1f89e53a2bdd630d2) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n020001b.63c", 0x300001, 0x40000, CRC(9b2eee8b) SHA1(420156256d5b628a62ea612edd526d293d2c7abc) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( joyjoyd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n021001a.038", 0x000001, 0x040000, CRC(ea512c9f) SHA1(094d8c06a1038dd38b74ced3d213a52b340062a6) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "021.s1", CRC(6956d778) SHA1(e3757776d60dc07d8e07c9ca61b223b14732f860) ) // n021001a.378

	NEO_BIOS_AUDIO_64K( "n021001a.478", CRC(058683ec) SHA1(2aff3dc18d078911ed3a09d48664faf5958b4ab5) )

	ROM_REGION( 0x080000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "021.v11", 0x000000, 0x080000, CRC(66c1e5c4) SHA1(7e85420021d4c39c36ed75a1cec567c5610ffce0) ) // n021001a.178

	ROM_REGION( 0x080000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "021.v21", 0x000000, 0x080000, CRC(8ed20a86) SHA1(d15cba5eac19ea56fdd4877541f1bb3eb755ebba) ) // n021001a.278

	ROM_REGION( 0x100000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n021001a.538", 0x000000, 0x40000, CRC(cb27be65) SHA1(bdadc0da89026af3ed0dc6a18f2449c0cb24ee0c) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n021001a.638", 0x000001, 0x40000, CRC(7e134979) SHA1(e33b30e39283963e8e806ccd12d9559de27c8bbe) )
	ROM_CONTINUE(             0x000003, 0x40000 )
ROM_END

ROM_START( kotmd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n016001a.038", 0x000001, 0x040000, CRC(d239c184) SHA1(feb139ce089385b6b1bc95970c4d7ae4fd8a7c7f) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n016001a.03c", 0x080001, 0x040000, CRC(7291a388) SHA1(16e22a8eef5391fa43d92d702f14a746dedf292b) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "016.s1", CRC(1a2eeeb3) SHA1(8d2b96d395020197bc59294b6b0c8d62b1d8d4dd) ) // n016001a.378

	NEO_BIOS_AUDIO_128K( "n016001a.4f8", CRC(40797389) SHA1(12ca00ba1d2d66d79bc64969661a52205cc98d66) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n016001a.1f8", 0x000000, 0x080000, CRC(c3df83ba) SHA1(2f015ccf99de241861e05e81ad47faf02aec3290) )
	ROM_LOAD( "n016001a.1fc", 0x080000, 0x080000, CRC(22aa6096) SHA1(c98fdc9fa589907cae1f7a2814fa32913d6c8648) )
	ROM_LOAD( "n016001b.1f8", 0x100000, 0x080000, CRC(df9a4854) SHA1(f9612d82ce476f8c973ce60a982ae8007bd051a1) )
	ROM_LOAD( "n016001b.1fc", 0x180000, 0x080000, CRC(71f53a38) SHA1(0fa03a2c719cc413ab163d166f93fcdc89646066) )

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n016001a.538", 0x000000, 0x40000, CRC(493db90e) SHA1(fb22e4f5437d9402c531779215cf675daa35401f) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n016001a.638", 0x000001, 0x40000, CRC(8bc1c3a0) SHA1(789f990b2b12bff7335a40a0ca6e64824dd6d4e2) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n016001a.53c", 0x100000, 0x40000, CRC(0d211945) SHA1(4edef3bdd73e402ab606ac27013a2b8c1467667c) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n016001a.63c", 0x100001, 0x40000, CRC(cc793bbf) SHA1(b88075e388d68601bb0e56f621a22abaf90ef39c) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n016001b.538", 0x200000, 0x40000, CRC(cabb7b58) SHA1(e7be9c459c17dddc3a812981e14fc2e0a3fb5ec3) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n016001b.638", 0x200001, 0x40000, CRC(fde45b59) SHA1(72ddca41b6cd595246eb8c8bb0c2e614c53e828c) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n016001b.53c", 0x300000, 0x40000, CRC(c7c20718) SHA1(52a2d7f4f8baede451959a351d2badf080b1e20e) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n016001b.63c", 0x300001, 0x40000, CRC(b89b4201) SHA1(74322700b9e8cf30b7d025be3909e93e1bfdaaf9) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( lbowlingd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n019001a.038", 0x000001, 0x040000, CRC(380e358d) SHA1(2f9683ca65abb2d046277a7642877f66a29d08f6) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "019.s1", CRC(5fcdc0ed) SHA1(86415077e7adc3ba6153eeb4fb0c62cf36e903fa) ) // n019001a.378

	NEO_BIOS_AUDIO_64K( "n019001a.478", CRC(535ec016) SHA1(301733768d2b962f58fc372e54f9d7bfd6615c21) )

	ROM_REGION( 0x100000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "019.v11", 0x000000, 0x080000, CRC(0fb74872) SHA1(38c555926c77576d63472bc075210c42e9ce13a3) ) // n019001a.178
	ROM_LOAD( "019.v12", 0x080000, 0x080000, CRC(029faa57) SHA1(7bbaa87e38929ab1e32df5f6a2ec0fd5001e7cdb) ) // n019001a.17c

	ROM_REGION( 0x080000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "019.v21", 0x000000, 0x080000, CRC(2efd5ada) SHA1(8ba70f5f665d566824333075227d9bce1253b8d8) ) // n019001a.278

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n019001a.538", 0x000000, 0x40000, CRC(17df7955) SHA1(992558200cbe7c0f9fc96cb6b1adb63ded28b833) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n019001a.638", 0x000001, 0x40000, CRC(84fd2c90) SHA1(b0ce2ba62d682f847f238eb5196340f466e6bcda) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n019001a.53c", 0x100000, 0x40000, CRC(67bf2d89) SHA1(282a29425eed00a85f88c332112bd9e0a95770cf) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n019001a.63c", 0x100001, 0x40000, CRC(cb4fbeb0) SHA1(a9a985ef66fe39111ccd37a4c1a26707d3bf3045) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n019001b.538", 0x200000, 0x40000, CRC(00d36f90) SHA1(8d47ea266dd2bf3ccbb9fb21ba860d9e9ec22db0) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n019001b.638", 0x200001, 0x40000, CRC(c2ddf431) SHA1(2ffbea4164f3099bdf8162c6ecc782d8badfab25) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n019001b.53c", 0x300000, 0x40000, CRC(4e971be9) SHA1(f137ad0eb9da8c4fffb5893ed694d97647f7e77b) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n019001b.63c", 0x300001, 0x40000, CRC(e67f8c81) SHA1(e0e8b24171a61dfe14649e7cff6f95d0a510cb55) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( lresortd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n024001a.038", 0x000001, 0x040000, CRC(5f0a5a4b) SHA1(69e33ed94f533528038fb157529b44dc940ab231) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "024.s1", CRC(5cef5cc6) SHA1(9ec305007bdb356e9f8f279beae5e2bcb3f2cf7b) ) // n024001a.378

	NEO_BIOS_AUDIO_128K( "n024001a.4f8", CRC(3d40a1c6) SHA1(d98b2b2893274db0cadc9c9718349086afadadc7) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n024001a.1f8", 0x000000, 0x080000, CRC(0722da38) SHA1(66a9b463d5277908b3a01c03de82b3de9118f2cb) )
	ROM_LOAD( "n024001a.1fc", 0x080000, 0x080000, CRC(670ce3ec) SHA1(9004aa85d4a9b0ecf9cf9357b073ed55a98fdb02) )
	ROM_LOAD( "n024001b.1f8", 0x100000, 0x080000, CRC(2e39462b) SHA1(b0a9b1a3377bf0369f3020192505c46ca52927d6) )
	ROM_LOAD( "n024001b.1fc", 0x180000, 0x080000, CRC(7944754f) SHA1(d42a46c5127c6c62041ebffb0007af8a24abd360) )

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n024001a.538", 0x000000, 0x40000, CRC(9f7995a9) SHA1(e3efdef66f5a6136ebe8fa9e3ff917323ab3fc5e) )
	ROM_CONTINUE( 0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n024001a.638", 0x000001, 0x40000, CRC(68c70bac) SHA1(7a6ddb1beb8cb6f6991d675affeb78226c18180e) )
	ROM_CONTINUE( 0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n024001a.53c", 0x100000, 0x40000, CRC(e122b155) SHA1(c9e759302fcf5aaf989463bf94157e45d76e68ea) )
	ROM_CONTINUE( 0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n024001a.63c", 0x100001, 0x40000, CRC(f18a9b02) SHA1(5cb9cf37de1b97ef680411beeff9ca262e77b067) )
	ROM_CONTINUE( 0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n024001b.538", 0x200000, 0x40000, CRC(e7138cb9) SHA1(d65c9e4f305cec30264355dd46a8ab413221dd82) )
	ROM_CONTINUE( 0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n024001b.638", 0x200001, 0x40000, CRC(08178e27) SHA1(e03137bf8e5bcd3c000113ec49da36f7100727e9) )
	ROM_CONTINUE( 0x200003, 0x40000 )
ROM_END

ROM_START( maglordd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n005001a.038", 0x000001, 0x040000, CRC(e51c3815) SHA1(19f36c8393191caf95a254ca52ce9e0012e6947a) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "005.s1", CRC(1c5369a2) SHA1(db0dba0a7dced6c9ca929c5abda491b05d84199c) ) // n005001a.378

	NEO_BIOS_AUDIO_64K( "n005001a.478", CRC(91ee1f73) SHA1(f060728543333a99216cc2879f7666a1f4235068) )

	ROM_REGION( 0x080000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "005.v11", 0x000000, 0x080000, CRC(cc0455fd) SHA1(a8ff4270e7705e263d25ff0b301f503bccea7e59) ) // n005001a.178

	ROM_REGION( 0x100000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "005.v21", 0x000000, 0x080000, CRC(f94ab5b7) SHA1(2c16985102e3585e08622d8c54ac5c60425b9ff8) ) // n005001a.278
	ROM_LOAD( "005.v22", 0x080000, 0x080000, CRC(232cfd04) SHA1(61b66a9decbbd1f500a8c186615e7fd077c6861e) ) // n005001a.27c

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n005001a.538", 0x000000, 0x40000, CRC(86aacd0d) SHA1(ee36e015908a7c087ace6cea0650822681066c94) )
	ROM_CONTINUE( 0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n005001a.638", 0x000001, 0x40000, CRC(b62658b5) SHA1(21a1d1f9ebe8c7a442c0b0a96f12af8047b8dbf3) )
	ROM_CONTINUE( 0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n005001a.53c", 0x100000, 0x40000, CRC(3997403e) SHA1(95e8375c897953055c952fd1fd3ff282fdc68928) )
	ROM_CONTINUE( 0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n005001a.63c", 0x100001, 0x40000, CRC(bd534fe2) SHA1(eebafc4a1daf650a6e7c3a64b2628e160e130b59) )
	ROM_CONTINUE( 0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n005001b.538", 0x200000, 0x40000, CRC(fbd1e9f1) SHA1(4faa14c164000e5581bb47788d2e8e1ee74ca0c6) )
	ROM_CONTINUE( 0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n005001b.638", 0x200001, 0x40000, CRC(a6461283) SHA1(a3eb28e584b0b91a0b5b372c932815cf4047d5bd) )
	ROM_CONTINUE( 0x200003, 0x40000 )
ROM_END

ROM_START( minasand )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n027001a.038", 0x000001, 0x040000, CRC(86805d5a) SHA1(9f9e300f4d4aef1bddb239580e8e5e3087957a50) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "027.s1", CRC(e5824baa) SHA1(8230ff7fe3cabeacecc762d90a084e893db84906) ) // n027001a.378

	NEO_BIOS_AUDIO_64K( "n027001a.478", CRC(19ef88ea) SHA1(8eca1a342d506e97dd116ce8ffe2242895b04c7a) )

	ROM_REGION( 0x100000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n027001a.178", 0x000000, 0x080000, CRC(79d65e8e) SHA1(8e5d8608e43564e5ce1d458a9e09b2c8100e3f4f) )
	ROM_LOAD( "n027001a.17c", 0x080000, 0x080000, CRC(0b3854d5) SHA1(27e951b47c0ab96f3c64704f913400020156895a) )

	ROM_REGION( 0x100000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "n027001a.278", 0x000000, 0x080000, CRC(0100e548) SHA1(627d16aba58602d28c865e93894f8d00d4815779) )
	ROM_LOAD( "n027001a.27c", 0x080000, 0x080000, CRC(0c31c5b0) SHA1(372168e5e6845eb5e2450a6f6daec26429b446c0) )

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n027001a.538", 0x000000, 0x40000, CRC(43f48265) SHA1(05500d56c808123b803be0efa71dd233a55793d1) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n027001a.638", 0x000001, 0x40000, CRC(f774d850) SHA1(5b63b4893b5b86b5c2ecf3e0be6d83d9b92e754c) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n027001a.53c", 0x100000, 0x40000, CRC(cbf9eef8) SHA1(6baf6c5f4fc52fc48d0e43014b11fdfe26e6db70) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n027001a.63c", 0x100001, 0x40000, CRC(14a81e58) SHA1(53216ad674e553829db3cc23d1e827c18d70c04e) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n027001b.538", 0x200000, 0x40000, CRC(3dae0a05) SHA1(0bf63e5676e3caab6f9d4895c9cbeb600bb6a8a1) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n027001b.638", 0x200001, 0x40000, CRC(0fb30b5b) SHA1(89f1176a55040d7ca0246231a9a0b027d2e0c304) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n027001b.53c", 0x300000, 0x40000, CRC(6979368e) SHA1(d1faae6fafbb7de21e7ee56356c30f18b7c4a130) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n027001b.63c", 0x300001, 0x40000, CRC(cfa90d59) SHA1(3185e00a030ace45f543b3a4ab6c101107727d01) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( mutnatd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n014001a.038", 0x000001, 0x040000, CRC(30cbd46b) SHA1(48357c8b704526da7101c06a120b096ec160a7bb) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "014.s1", CRC(99419733) SHA1(b2524af8704941acc72282aa1d62fd4c93e3e822) ) // n014001a.378

	NEO_BIOS_AUDIO_128K( "n014001a.4f8", CRC(2db6862d) SHA1(35cfe136edb09f0b13d312527dd71b4250c04383) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n014001a.1f8", 0x000000, 0x080000, CRC(8db2effe) SHA1(4bdfc36ed3c986ef153e03efbc581536876a3ebb) )
	ROM_LOAD( "n014001a.1fc", 0x080000, 0x080000, CRC(a49fe238) SHA1(378842d7fa93496ee103be3a0996c6943d285274) )
	ROM_LOAD( "n014001b.1f8", 0x100000, 0x080000, CRC(2ba17cb7) SHA1(99fa247c003b74b5da56631d11a63045dd5ef0d5) )
	ROM_LOAD( "n014001b.1fc", 0x180000, 0x080000, CRC(42419a29) SHA1(5185c978edb89a1764ee0b874be980b61280c822) )

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n014001a.538", 0x000000, 0x40000, CRC(83d59ccf) SHA1(90daecf9594715ac33c4a6294f481914351c702f) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n014001a.638", 0x000001, 0x40000, CRC(9e115a04) SHA1(16f04c7b3c5f6888591e9c2e385efb984e393571) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n014001a.53c", 0x100000, 0x40000, CRC(b2f1409d) SHA1(ab3af0fb4f4ca4afba098a6f8e9926b530a279df) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n014001a.63c", 0x100001, 0x40000, CRC(1bb648c1) SHA1(21afaf1e5ea541d5ac9bb273887baf662c52dfab) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n014001b.538", 0x200000, 0x40000, CRC(eaa2801a) SHA1(fec321bc839e5eeb4bfc88785276ee7af345f6c0) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n014001b.638", 0x200001, 0x40000, CRC(32bf4a2d) SHA1(f68419c9414dfbcc67c3a4b8cbef42b0b5fda0bc) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n014001b.53c", 0x300000, 0x40000, CRC(c718b731) SHA1(37eb725d43ecda891f67b607b5d5f039fc81a8cb) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n014001b.63c", 0x300001, 0x40000, CRC(7d120067) SHA1(d0e4f0f8c1455a51b5d769fa4bcd5f29bd894c13) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( ncombatd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n009001a.038", 0x000001, 0x040000, CRC(89660a31) SHA1(ac37a1060ee82733d8efef8c50f79672fe312097) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "009.s1", CRC(d49afee8) SHA1(77615f12edf08ae8f1353f7a056a8f3a50d3ebdc) ) // n009001a.378

	NEO_BIOS_AUDIO_64K( "n009001a.478", CRC(83821d6e) SHA1(687ad38aa20a113c4f59e7ebc1c911bb8e635ad7) )

	ROM_REGION( 0x180000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "009.v11", 0x000000, 0x080000, CRC(cf32a59c) SHA1(af5b7fcd8a4aff1307c0a1d937e5f0460c32de79) ) // n009001a.178
	ROM_LOAD( "009.v12", 0x080000, 0x080000, CRC(7b3588b7) SHA1(a4e6d9d4113ff4ce48b371f65e9187d551821d3b) ) // n009001a.17c
	ROM_LOAD( "009.v13", 0x100000, 0x080000, CRC(505a01b5) SHA1(9426a4f5b31e16f74e72e61951c189a878f211c5) ) // n009001b.178

	ROM_REGION( 0x080000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "009.v21", 0x000000, 0x080000, CRC(365f9011) SHA1(aebd292214ab280b05ee9e759b7e9a681a099c4a) ) // n009001a.278

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n009001a.538", 0x000000, 0x40000, CRC(0147a4b5) SHA1(0a2f60bb7166bd5a2ad669820b0f26d630e94958) )
	ROM_CONTINUE( 0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n009001a.638", 0x000001, 0x40000, CRC(e3d367f8) SHA1(8129c6845b8969f26c7cfe8761bb2bb07e5dc549) )
	ROM_CONTINUE( 0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n009001a.53c", 0x100000, 0x40000, CRC(4df6123a) SHA1(53970d86a848f498ebd5676c0a9d6fe8e026def8) )
	ROM_CONTINUE( 0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n009001a.63c", 0x100001, 0x40000, CRC(1c1f6101) SHA1(9594d199bafa9317bcf8b7447442171ea9b1056d) )
	ROM_CONTINUE( 0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n009001b.538", 0x200000, 0x40000, CRC(19441c78) SHA1(6355039f445456ffe32a512b635e365c5519d0c7) )
	ROM_CONTINUE( 0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n009001b.638", 0x200001, 0x40000, CRC(f417f9ac) SHA1(438e76b54bb82517a57cb3405a99dda0b3d66dc0) )
	ROM_CONTINUE( 0x200003, 0x40000 )
ROM_END

ROM_START( ncommandd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n050001a.038", 0x000001, 0x040000, CRC(fdaaca42) SHA1(aa32936bbe8ee53e717a3582847af89d1e160ff4) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n050001a.03c", 0x080001, 0x040000, CRC(b34e91fe) SHA1(3fbf40b9473bc6b0633c62fffdebc43d86785c7d) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "050.s1", CRC(db8f9c8e) SHA1(11cb82cf3c4d0fc2da5df0c26410a64808093610) ) // n050001a.378

	NEO_BIOS_AUDIO_64K( "n050001a.4f8", CRC(26e93026) SHA1(ea38754748ee2a9250864cd1836db463a1b29b1e) )

	ROM_REGION( 0x180000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n050001a.1f8", 0x000000, 0x080000, CRC(222e71c8) SHA1(5a598414b859ae6fbe4fb1b4bf622b1198232864) )
	ROM_LOAD( "n050001a.1fc", 0x080000, 0x080000, CRC(12acd064) SHA1(c2d7f55df6e49c54c0cab6d5db4cb82f97c6bab9) )
	ROM_LOAD( "050.v2",    0x100000, 0x080000, CRC(80b8a984) SHA1(950cf0e78ceffa4037663f1086fbbc88588f49f2) ) // n050001b.1f8

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n050001a.538", 0x000000, 0x40000, CRC(73acaa79) SHA1(1394c93132337469e283053f34c83658a9df771e) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n050001a.638", 0x000001, 0x40000, CRC(7b24359f) SHA1(99c5f59d479afbbc6ab8ef9dc4f90b9b5d42a199) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n050001a.53c", 0x100000, 0x40000, CRC(ad56623d) SHA1(afeaeed8917f259905a5cb46deb42bf6b0e7fd35) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n050001a.63c", 0x100001, 0x40000, CRC(0913a784) SHA1(5cee03ff0b41c58ad0b663c4bf100ae4a2152ee1) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n050001b.538", 0x200000, 0x40000, CRC(c8d763cd) SHA1(1d489c22bedd324d19cb02bed874e986f2627152) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n050001b.638", 0x200001, 0x40000, CRC(574612ec) SHA1(6c5863f2fc7b63808e8762aa839614919034aaa8) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n050001b.53c", 0x300000, 0x40000, CRC(63829529) SHA1(132f835fc2a6ca073700b1935ce3ebd32ba37f3e) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n050001b.63c", 0x300001, 0x40000, CRC(990d302a) SHA1(e0d07eb287b2ad143c72eeef39a3455d9d802a4a) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( ridherod )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n006001a.038", 0x000001, 0x040000, CRC(dabfac95) SHA1(234750f08954a94b2846f7ab79b67d6db2b67f6e) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_64K( "n006001a.378", CRC(197d1a28) SHA1(3f6ec453ebdead50c9fabd71071817b699a8a82c) )

	NEO_BIOS_AUDIO_64K( "n006001a.478", CRC(f7196558) SHA1(88c9183db5cb24849a8a548cd48d0732ee1e6219) )

	ROM_REGION( 0x100000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "006.v11", 0x000000, 0x080000, CRC(cdf74a42) SHA1(a17106cc3f9e5c5d52b4def861c0545a98151da2) ) // n006001a.178
	ROM_LOAD( "006.v12", 0x080000, 0x080000, CRC(e2fd2371) SHA1(cc95297bee7ffbdcb24ac4daeb5307cb39a52067) ) // n006001a.17c

	ROM_REGION( 0x200000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "006.v21", 0x000000, 0x080000, CRC(94092bce) SHA1(1a2906271fe6bc396898a756153629a5862930eb) ) // n006001a.278
	ROM_LOAD( "006.v22", 0x080000, 0x080000, CRC(4e2cd7c3) SHA1(72fb215a4f208a22a764e801186d1643d3d840ca) ) // n006001a.27c
	ROM_LOAD( "006.v23", 0x100000, 0x080000, CRC(069c71ed) SHA1(f450e9f60cd6ef846dbc77993159ec6157fb64e7) ) // n006001b.278
	ROM_LOAD( "006.v24", 0x180000, 0x080000, CRC(89fbb825) SHA1(656a97c6a8832dab3a5e1577d9cd257b561cc356) ) // n006001b.27c

	ROM_REGION( 0x200000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n006001a.538", 0x000000, 0x40000, CRC(24096241) SHA1(60a3dd2400be7208c7a471a813621a778f083240) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n006001a.638", 0x000001, 0x40000, CRC(df6a5b00) SHA1(ffd55c36847b0caa7b94b102ef3409d89e0d66c7) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n006001a.53c", 0x100000, 0x40000, CRC(7026a3a2) SHA1(55f70d2604832125c06742d75ce8ccf5c047d580) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n006001a.63c", 0x100001, 0x40000, CRC(15220d51) SHA1(72ad9e0381f84a33219255d42223bca01a23927c) )
	ROM_CONTINUE(             0x100003, 0x40000 )
ROM_END

ROM_START( roboarmyd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n032001a.038", 0x000001, 0x040000, CRC(99c7b4fc) SHA1(06a5bd4dd8f6db81eb36d0a8f0612caa1c917325) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "032.s1", CRC(ac0daa1b) SHA1(93bae4697dc403fce19422752a514326ccf66a91) ) // n032001a.378

	NEO_BIOS_AUDIO_128K( "032e.m1", CRC(98edc671) SHA1(04ed65ccaa1197fa55fcefe2caed2772e7040bdb) ) // n032001a.4f8

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "032e.v1", 0x000000, 0x080000, CRC(daff9896) SHA1(2f8a39b98ff2f4a0c8901b1befcc69e0cc5f5aed) ) // n032001a.1f8
	ROM_LOAD( "032e.v2", 0x080000, 0x080000, CRC(8781b1bc) SHA1(4e3cc22ac0acd4033cd4a327269c68b5f56bbe34) ) // n032001a.1fc
	ROM_LOAD( "032e.v3", 0x100000, 0x080000, CRC(b69c1da5) SHA1(7d5ea49338aeef711fc64755abed51fcdd939d48) ) // n032001b.1f8
	ROM_LOAD( "032e.v4", 0x180000, 0x080000, CRC(2c929c17) SHA1(7e053035573de9f601de80d200d09ed4844506fe) ) // n032001b.1fc

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n032001a.538", 0x000000, 0x40000, CRC(e3afaf17) SHA1(b11a45e77f10764f8c845a258d4add74146f1ffe) )
	ROM_CONTINUE( 0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n032001a.638", 0x000001, 0x40000, CRC(3a098b3b) SHA1(93520f664a76de7fac0baeb81daae8943aef0749) )
	ROM_CONTINUE( 0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n032001a.53c", 0x100000, 0x40000, CRC(17098f54) SHA1(69c775685f29e6b6af4f2bed1570bdd7a9c20cec) )
	ROM_CONTINUE( 0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n032001a.63c", 0x100001, 0x40000, CRC(8e3b2b88) SHA1(3ae3c3a5b64a523b294f1166f5506c850edc7f15) )
	ROM_CONTINUE( 0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n032001b.538", 0x200000, 0x40000, CRC(13cbb7c5) SHA1(2f3a92dccd440a5dd9542f423ac74ee3f4255066) )
	ROM_CONTINUE( 0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n032001b.638", 0x200001, 0x40000, CRC(b6f5fc62) SHA1(5d520d2cdd2d99e7d1c9f3c20448464318c8a03c) )
	ROM_CONTINUE( 0x200003, 0x40000 )
ROM_END

ROM_START( sengokud )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n017001a.038", 0x000001, 0x040000, CRC(4483bae1) SHA1(ca5f41be42cd9ce1a2c5007f068514500849a7f4) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n017001a.03c", 0x080001, 0x040000, CRC(d0d55b2a) SHA1(3800154495fbc2f62a539604bf6e5f156316dccd) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "017.s1", CRC(b246204d) SHA1(73dce64c61fb5bb7e836a8e60f081bb77d80d281) ) // n017001a.378

	NEO_BIOS_AUDIO_128K( "n017001a.4f8", CRC(e7bc4a94) SHA1(236d8dddafe5215558f3b0fbb2de3d6c39dd622b) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n017001a.1f8", 0x000000, 0x080000, CRC(205258a7) SHA1(4cd463a78575d7e74c871660588dc0fe17cce07d) )
	ROM_LOAD( "n017001a.1fc", 0x080000, 0x080000, CRC(6fbe52c8) SHA1(487f07968854ba3238ba2c612c8b20196f94cab2) )
	ROM_LOAD( "n017001b.1f8", 0x100000, 0x080000, CRC(6421bdf3) SHA1(823ffcbb9fc8b1219857b8cb6e089e2e21144ab3) )
	ROM_LOAD( "n017001b.1fc", 0x180000, 0x080000, CRC(1f9578fb) SHA1(7ccdb0e960d6e425e773a99208180dcf5ee7856f) )

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n017001a.538", 0x000000, 0x40000, CRC(e834b925) SHA1(08cfdcf232f3319f62b00cfec5c02b55d7c3405e) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n017001a.638", 0x000001, 0x40000, CRC(96de5eb9) SHA1(a70dfbffb109ddec5b4a2c6f60756d6717fce03b) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n017001a.53c", 0x100000, 0x40000, CRC(66be6d46) SHA1(3cd5bf09f994159caff23ba01700e7531ebc5b57) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n017001a.63c", 0x100001, 0x40000, CRC(25f5fd7b) SHA1(f1b2d58c6b73f3001751bf4c81f3d8664c96091c) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n017001b.538", 0x200000, 0x40000, CRC(443c552c) SHA1(75203f58935eb6a554542bb6ece457f8a2b51adb) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n017001b.638", 0x200001, 0x40000, CRC(afbd5b0b) SHA1(639fecb5afd5fb31ba169149d61830330169d7df) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n017001b.53c", 0x300000, 0x40000, CRC(ecb41adc) SHA1(741ddfdb8cbfacd95c37243dbf098a09ad6d6f0b) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n017001b.63c", 0x300001, 0x40000, CRC(78b25278) SHA1(c1ed3be0e0bc5c6bebaee1bb851cfb9c0b8b243f) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( sengoku2d )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n040001a.038", 0x000001, 0x040000, CRC(d1bf3fa5) SHA1(4a6c82d9294980eca6f9311d62f4d683baca173e) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n040001a.03c", 0x080001, 0x040000, CRC(ee9d0bb4) SHA1(27748b3a1b2e59cda29a85a6a467e1a46be3fe60) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "040.s1", CRC(cd9802a3) SHA1(f685d4638f4f68e7e3f101c0c39128454536721b) ) // n040001a.378

	NEO_BIOS_AUDIO_128K( "n040001a.4f8", CRC(9902dfa2) SHA1(af6284c5298328156726b76b968995ad25fdf4de) )

	ROM_REGION( 0x300000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n040001a.1f8", 0x000000, 0x080000, CRC(e6e9d82f) SHA1(a4691ef7719c55fa665dbe8f4420008cf6f23ae2) )
	ROM_LOAD( "n040001a.1fc", 0x080000, 0x080000, CRC(0504e71e) SHA1(856a200e2e4c39c0985d10b1dcd75e89e69b6f5d) )
	ROM_LOAD( "n040001b.1f8", 0x100000, 0x080000, CRC(e6c57d21) SHA1(e1f1403c3340be1ab66f027b2678bee3267b9f3c) )
	ROM_LOAD( "n040001b.1fc", 0x180000, 0x080000, CRC(000d319d) SHA1(88424ceca50e03ed41bad0493461bccfee519ec5) )
	ROM_LOAD( "n040001c.1f8", 0x200000, 0x080000, CRC(6650bc9a) SHA1(43e9da8176b9c282eaaaf8963fd7c7bd83d61953) )
	ROM_LOAD( "n040001c.1fc", 0x280000, 0x080000, CRC(c6358d62) SHA1(ca1d72a8a3ea9a2b5a800aeb091098d723eef963) )

	ROM_REGION( 0x600000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n040001a.538", 0x000000, 0x40000, CRC(da18aaed) SHA1(926500715ba30a5fad128ba877ca5f59bd98399b) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n040001a.638", 0x000001, 0x40000, CRC(5b27c829) SHA1(166ff9359b819a068763e868da69cf67976ec8c8) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n040001a.53c", 0x100000, 0x40000, CRC(19796c4f) SHA1(cf15a65c6bc5243978df6c91b3dce120e4b6db4a) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n040001a.63c", 0x100001, 0x40000, CRC(e8b46e26) SHA1(5b47903fd7b9783e6e18bbff33e0d7747305bda9) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n040001b.538", 0x200000, 0x40000, CRC(891b6386) SHA1(9d5e3b2fb6c2247712637f0f7b647042e0485eb6) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n040001b.638", 0x200001, 0x40000, CRC(93d25955) SHA1(039567a2426794bac9a502d7a46ed13bcc804764) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	// These probably not used. 3xxxxx same roms as 2xxxxx
	ROM_LOAD32_BYTE( "n040001c.538", 0x400000, 0x40000, CRC(c5eaabe8) SHA1(724f0b47e7e166b65b5e5fee790850aed15d2885) )
	ROM_CONTINUE(             0x400002, 0x40000 )
	ROM_LOAD32_BYTE( "n040001c.638", 0x400001, 0x40000, CRC(432bd7d0) SHA1(662179ed7c82f9f825b89650761db093ef9f7467) )
	ROM_CONTINUE(             0x400003, 0x40000 )
	ROM_LOAD32_BYTE( "n040001c.53c", 0x500000, 0x40000, CRC(22633905) SHA1(3afcf2bf752afa1593f144a8a9749736a09f6738) )
	ROM_CONTINUE(             0x500002, 0x40000 )
	ROM_LOAD32_BYTE( "n040001c.63c", 0x500001, 0x40000, CRC(ba3f54b2) SHA1(796ac0d021552b2ed1b95f11cad1e5e1530abcc7) )
	ROM_CONTINUE(             0x500003, 0x40000 )
ROM_END

ROM_START( socbrawld )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n031001a.038", 0x000001, 0x040000, CRC(9fa17911) SHA1(b5a86cc8c8b6e44e392deb6e975ee59076c4392a) )
	ROM_CONTINUE (                 0x000000, 0x040000 )

	NEO_SFIX_128K( "031.s1", CRC(4c117174) SHA1(26e52c4f628338a9aa1c159517cdf873f738fb98) ) // n031001a.378

	NEO_BIOS_AUDIO_128K( "n031001a.4f8", CRC(bc45269b) SHA1(19b82e7174a6fe5caaec35c0603944a090a43b65) )

	ROM_REGION( 0x200000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n031001a.1f8", 0x000000, 0x080000, CRC(670dc165) SHA1(f75d174cfc0d4c16375c58069b923380ae8c6923) )
	ROM_LOAD( "n031001a.1fc", 0x080000, 0x080000, CRC(abb9537b) SHA1(0f272ef6bfdb1b5b0580fe9d01070e4f60b383ff) )
	ROM_LOAD( "n031001b.1f8", 0x100000, 0x080000, CRC(600be43e) SHA1(5639e239910f0fb07f26e4f9816efd77b04f6152) )
	ROM_LOAD( "n031001b.1fc", 0x180000, 0x080000, CRC(88d30359) SHA1(884cabd8a6ccbdd470aab3b7325fdeade01679f0) )

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n031001a.538", 0x000000, 0x40000, CRC(945bf77c) SHA1(0f971d5c21c051d2298866b69c96715f583fe521) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n031001a.638", 0x000001, 0x40000, CRC(6708fc58) SHA1(230253fbe761cb1164efb9a3c91ac1f24f57295b) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n031001a.53c", 0x100000, 0x40000, CRC(9a210d0d) SHA1(be9b9587c138679e2fb299455d98e2ac6ffad63b) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n031001a.63c", 0x100001, 0x40000, CRC(9a97c680) SHA1(746a5cb5bf713c806cef24d21347f5b96c86ccab) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n031001b.538", 0x200000, 0x40000, CRC(057dbb51) SHA1(cab14d98cbbfc0e5714082fd2db8c73e9c6cd684) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n031001b.638", 0x200001, 0x40000, CRC(434c17c8) SHA1(629dc40ab09ac0a2f55234bc34c4ba63c0b8912f) )
	ROM_CONTINUE(             0x200003, 0x40000 )
ROM_END

ROM_START( superspyd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n011001a.038", 0x000001, 0x040000, CRC(2e949e32) SHA1(c5a5bb996c5c0224b27813a76223c56860ddb399) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n011001a.03c", 0x080001, 0x040000, CRC(54443d72) SHA1(5cb78d50996c1f9a182e9350d94ba2953463ed4b) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "011.s1", CRC(ec5fdb96) SHA1(8003028025ac7bf531e568add6ba66c02d0b7e84) ) // n011001a.378

	NEO_BIOS_AUDIO_64K( "n011001a.478", CRC(64455806) SHA1(454e95503be8ec5dd2332da1ce08c832a2ab81b8) )

	ROM_REGION( 0x180000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n011001a.178", 0x000000, 0x080000, CRC(b993bc83) SHA1(b7689a57120b9eb3d23b6675f8791c117360a267) )
	ROM_LOAD( "n011001a.17c", 0x080000, 0x080000, CRC(d7a059b1) SHA1(b13c1c674f66cb6852f0a206554e4616f5fde236) )
	ROM_LOAD( "011.v12", 0x100000, 0x080000, CRC(9f513d5a) SHA1(37b04962f0b8e2a74abd35c407337a6151dc4e95) ) // n011001b.178

	ROM_REGION( 0x080000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "011.v21", 0x000000, 0x080000, CRC(426cd040) SHA1(b2b45189837c8287223c2b8bd4df9525b72a3f16) ) // n011001a.278

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n011001a.538", 0x000000, 0x40000, CRC(239f22c4) SHA1(91f985fb9acb36ab5f8877f62c0476a291f3b591) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n011001a.638", 0x000001, 0x40000, CRC(5f2e5184) SHA1(b2704eff6815da611f0f2ad15f2a85d482a111d3) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n011001a.53c", 0x100000, 0x40000, CRC(ce80c326) SHA1(3f1f72d923dde87e87bc74080cc1858f42413ab2) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n011001a.63c", 0x100001, 0x40000, CRC(79b3e0b1) SHA1(1f627f7b8d86292d4f4cdc0f15782d060a91b551) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n011001b.538", 0x200000, 0x40000, CRC(1edcf268) SHA1(a691f76980e7a0da63948a5d75f32afa6c92c9c3) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n011001b.638", 0x200001, 0x40000, CRC(b2afe822) SHA1(56d623e4a468ac88c6bbc54ff6f640a7aa5f93f5) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n011001b.53c", 0x300000, 0x40000, CRC(a41602a0) SHA1(95ee2162de50be72982edcecb437995a43d39a07) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n011001b.63c", 0x300001, 0x40000, CRC(d425f967) SHA1(4085782d440ad265ae45f43c83b1d1fa96d15524) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( tpgolfd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n003001a.038", 0x000001, 0x040000, CRC(542e93d9) SHA1(530d8e344481ae98edd4ca8b86146c44f587228f) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n003001a.03c", 0x080001, 0x040000, CRC(03f1bead) SHA1(b2e40d936636e5d2108fcdf4f440095b3e6da9b5) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "003.s1", CRC(7b3eb9b1) SHA1(39cd8bad9f8bfdeb8ac681b5b79ae5aa81c8dd5f) ) // n003001a.378

	NEO_BIOS_AUDIO_64K( "003cd.m1", CRC(7851d0d9) SHA1(d021cef958cc37ab170b78d7a4b3ae94947e4d13) ) // n003001a.478

	ROM_REGION( 0x080000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "003.v11", 0x000000, 0x080000, CRC(ff97f1cb) SHA1(defa249d46ae220f7bfa70746f5202bbbcc3e5fe) ) // n003001a.178

	ROM_REGION( 0x100000, "ymsnd:adpcmb", 0 )
	ROM_LOAD( "003.v21", 0x000000, 0x080000, CRC(d34960c6) SHA1(36d5877d5e42aab943f4d693159f4f3ad8b0addc) ) // n003001a.278
	ROM_LOAD( "003.v22", 0x080000, 0x080000, CRC(9a5f58d4) SHA1(2b580595e1820430a36f06fd3e0e0b8f7d686889) ) // n003001a.27c

	ROM_REGION( 0x400000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n003001a.538", 0x000000, 0x40000, CRC(67633f80) SHA1(951e11f5f74434a3ce9b11bf75b822b2ffbf2c8f) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n003001a.638", 0x000001, 0x40000, CRC(ba49936b) SHA1(c5eb478da0dc409bc5853438387a93d9a2ecdd04) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n003001a.53c", 0x100000, 0x40000, CRC(bed644d0) SHA1(687ebf0928983e6e795619124a90696c3de3d55d) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n003001a.63c", 0x100001, 0x40000, CRC(7fc96498) SHA1(f97da62165388d321ef6e31b3121b14e17fa9a5f) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n003001b.538", 0x200000, 0x40000, CRC(977a0ea9) SHA1(a2704d9a4a576058feacd237bb7ba28508df0207) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n003001b.638", 0x200001, 0x40000, CRC(a56853ec) SHA1(242e65c73b63adc0cd527bcdb03ac82fde5be5ef) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n003001b.53c", 0x300000, 0x40000, CRC(bc0ebc0e) SHA1(ed6c4b8b126ea66e75666358c02cbfe2e90985fe) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n003001b.63c", 0x300001, 0x40000, CRC(81347ea7) SHA1(8f7b78c91f449ba8e8d449ad436dd5421b6f12a6) )
	ROM_CONTINUE(             0x300003, 0x40000 )
ROM_END

ROM_START( trallyd )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n038001a.038", 0x000001, 0x040000, CRC(400bed38) SHA1(9ccc6a505e98e964db9253b50ae549a8d13beffb) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n038001a.03c", 0x080001, 0x040000, CRC(77196e9a) SHA1(31490ce2b97f67e9571ace32d97217232113fb72) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "038.s1", CRC(fff62ae3) SHA1(6510a762ea41557a8938cbfc0557cd5921306061) ) // n038001a.378

	NEO_BIOS_AUDIO_64K( "n038001a.4f8", CRC(308c4a8d) SHA1(6b1e5790442bcf4e3a9fb896bbd293eb33fb4990) )

	ROM_REGION( 0x180000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n038001a.1f8", 0x000000, 0x080000, CRC(1c93fb89) SHA1(a5056e33552e3e6fc3570d41e893a73d78086077) )
	ROM_LOAD( "n038001a.1fc", 0x080000, 0x080000, CRC(39f18253) SHA1(97622e15ebc180dc24d5b9049d6603cbe039dc81) )
	ROM_LOAD( "038.v2",    0x100000, 0x080000, CRC(ddd8d1e6) SHA1(65c819fa2392f264f5a1a0a4967c96775732500b) ) // n038001b.1f8

	ROM_REGION( 0x300000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n038001a.538", 0x000000, 0x40000, CRC(4d002ecb) SHA1(07330d6cbcd126bd67c702cc351ac4f668108e55) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n038001a.638", 0x000001, 0x40000, CRC(6b2f79de) SHA1(7725b9b66738a6f9fe9456cc6aadd4fa98d50bff) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n038001a.53c", 0x100000, 0x40000, CRC(b0be56db) SHA1(f511e1ef9074eec9bff37f22607cd5b491860ee7) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n038001a.63c", 0x100001, 0x40000, CRC(091f38b4) SHA1(0e579029524f004370d1c93d7b14ad47243bee66) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n038001b.538", 0x200000, 0x40000, CRC(2f213750) SHA1(fe5a8cd26b52928afeece5504ecca7ec452b7027) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n038001b.638", 0x200001, 0x40000, CRC(268be38b) SHA1(98f9dfee915ddf8d858297075c7b7d6731527aa3) )
	ROM_CONTINUE(             0x200003, 0x40000 )
ROM_END

ROM_START( wh1d )
	ROM_REGION( 0x100000, "maincpu", 0 )
	ROM_LOAD16_BYTE ( "n053001a.038", 0x000001, 0x040000, CRC(ab39923d) SHA1(be9fc3c89a452e64d02231d531bb298d201ef002) )
	ROM_CONTINUE (                 0x000000, 0x040000 )
	ROM_LOAD16_BYTE ( "n053001a.03c", 0x080001, 0x040000, CRC(5adc98ef) SHA1(0c87725b343f7705f974de71c4bc46afdc75c80b) )
	ROM_CONTINUE (                 0x080000, 0x040000 )

	NEO_SFIX_128K( "053.s1", CRC(8c2c2d6b) SHA1(87fa79611c6f8886dcc8766814829c669c65b40f) ) // n053001a.378

	NEO_BIOS_AUDIO_128K( "053.m1", CRC(1bd9d04b) SHA1(65cd7b002123ed1a3111e3d942608d0082799ff3) ) // n053001a.4f8

	ROM_REGION( 0x300000, "ymsnd:adpcma", 0 )
	ROM_LOAD( "n053001a.1f8", 0x000000, 0x080000, CRC(77994663) SHA1(7adaddf13177b1d18604611dfae7fc43b35a0766) )
	ROM_LOAD( "n053001a.1fc", 0x080000, 0x080000, CRC(d74ad0da) SHA1(fe71db5808d46f7b56ea7603e500534cd8ab8beb) )
	ROM_LOAD( "n053001b.1f8", 0x100000, 0x080000, CRC(9d5fe808) SHA1(825eb3727d67e1cf8d8e254576de52952a35c25c) )
	ROM_LOAD( "n053001b.1fc", 0x180000, 0x080000, CRC(883fb383) SHA1(ceef987b5e8ce9c0201eb0c66628456b99b41fd2) )
	ROM_LOAD( "n053001c.1f8", 0x200000, 0x080000, CRC(b4ff60d7) SHA1(a1615ec7b309839fd0e690e57d19ab5a857eef1d) )
	ROM_LOAD( "n053001c.1fc", 0x280000, 0x080000, CRC(b358e4f5) SHA1(6b74306beb801f9e35e1a948b2508a38facb2080) )

	ROM_REGION( 0x600000, "sprites", 0 )
	ROM_LOAD32_BYTE( "n053001a.538", 0x000000, 0x40000, CRC(ad8fcc5d) SHA1(67683d40fa438032a3e9f5997c7ca5b798f50325) )
	ROM_CONTINUE(             0x000002, 0x40000 )
	ROM_LOAD32_BYTE( "n053001a.638", 0x000001, 0x40000, CRC(3182b4db) SHA1(371f898f5ef28b1efe8129fa6837ee31452e0881) )
	ROM_CONTINUE(             0x000003, 0x40000 )
	ROM_LOAD32_BYTE( "n053001a.53c", 0x100000, 0x40000, CRC(0dca726e) SHA1(9c9ea623102818b0c551a998be8b909c16967896) )
	ROM_CONTINUE(             0x100002, 0x40000 )
	ROM_LOAD32_BYTE( "n053001a.63c", 0x100001, 0x40000, CRC(1cb0a840) SHA1(c52b1dd8b4860d1bcff207f0f7c2278dfa195219) )
	ROM_CONTINUE(             0x100003, 0x40000 )
	ROM_LOAD32_BYTE( "n053001b.538", 0x200000, 0x40000, CRC(bb807a43) SHA1(f0583c2bd3ad69f12d3635edece4480414497395) )
	ROM_CONTINUE(             0x200002, 0x40000 )
	ROM_LOAD32_BYTE( "n053001b.638", 0x200001, 0x40000, CRC(c9f439f8) SHA1(be7ba30e5cfe22341f61ea2571cec551a5793bf3) )
	ROM_CONTINUE(             0x200003, 0x40000 )
	ROM_LOAD32_BYTE( "n053001b.53c", 0x300000, 0x40000, CRC(e913f93c) SHA1(af17419e46aa4f4809fc2f620a6e2d109fe17197) )
	ROM_CONTINUE(             0x300002, 0x40000 )
	ROM_LOAD32_BYTE( "n053001b.63c", 0x300001, 0x40000, CRC(80441c48) SHA1(fdfab6abd4e2212635c47270df27108c1904a15b) )
	ROM_CONTINUE(             0x300003, 0x40000 )
	ROM_LOAD32_BYTE( "n053001c.538", 0x400000, 0x40000, CRC(3c359a14) SHA1(3415bc48511d57bb54f926df1e282ee02787776d) )
	ROM_CONTINUE(             0x400002, 0x40000 )
	ROM_LOAD32_BYTE( "n053001c.638", 0x400001, 0x40000, CRC(7c4b85b4) SHA1(ae7b199f6e59b1b697c36e21ddfc525d6ad77c83) )
	ROM_CONTINUE(             0x400003, 0x40000 )
	ROM_LOAD32_BYTE( "n053001c.53c", 0x500000, 0x40000, CRC(b1327d84) SHA1(02f58cb1a18448f1f3c3752bb802b6f737151b9d) )
	ROM_CONTINUE(             0x500002, 0x40000 )
	ROM_LOAD32_BYTE( "n053001c.63c", 0x500001, 0x40000, CRC(959f29db) SHA1(f1126098840fb602c8b3349111e5954b73a66934) )
	ROM_CONTINUE(             0x500003, 0x40000 )
ROM_END


GAME( 1993, 3countbd,  3countb,  neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "3 Count Bout (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, 2020bbd,   2020bb,   neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK / Pallas", "2020 Super Baseball (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, alpham2d,  alpham2,  neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Alpha Mission II (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1992, androdund, androdun, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "Visco", "Andro Dunos (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1992, aofd,      aof,      neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Art of Fighting (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, bakatonod, bakatono, neogeo_mj,       neogeo,   neogeo_state, init_neogeo,   ROT0, "Monolith Corp.", "Bakatonosama Mahjong Manyuki (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, bstarsd,   bstars,   neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Baseball Stars Professional (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, burningfd, burningf, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Burning Fight (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, crswordd,  crsword,  neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "Alpha Denshi Co.", "Crossed Swords (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, cyberlipd, cyberlip, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Cyber-Lip (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, eightmand, eightman, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK / Pallas", "Eight Man (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, fatfury1d, fatfury1, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Fatal Fury (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1992, fbfrenzyd, fbfrenzy, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Football Frenzy (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, gpilotsd,  gpilots,  neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Ghost Pilots (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, joyjoyd,   joyjoy,   neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Puzzled (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, kotmd,     kotm,     neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "King of the Monsters (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, lbowlingd, lbowling, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "League Bowling (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1992, lresortd,  lresort,  neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Last Resort (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, maglordd,  maglord,  neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "Alpha Denshi Co.", "Magician Lord (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, minasand,  minasan,  neogeo_mj,       neogeo,   neogeo_state, init_neogeo,   ROT0, "Monolith Corp.", "Minnasanno Okagesamadesu (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1992, mutnatd,   mutnat,   neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Mutation Nation (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, ncombatd,  ncombat,  neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "Alpha Denshi Co.", "Ninja Combat (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1992, ncommandd, ncommand, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "Alpha Denshi Co", "Ninja Commando (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, ridherod,  ridhero,  neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Riding Hero (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, roboarmyd, roboarmy, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Robo Army (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, sengokud,  sengoku,  neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Sengoku (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1993, sengoku2d, sengoku2, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Sengoku 2 (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, socbrawld, socbrawl, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Soccer Brawl (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, superspyd, superspy, neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "The Super Spy (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1990, tpgolfd,   tpgolf,   neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "SNK", "Top Player's Golf (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1991, trallyd,   trally,   neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "Alpha Denshi Co.", "Thrash Rally (MGD2)", MACHINE_SUPPORTS_SAVE )
GAME( 1992, wh1d,      wh1,      neogeo_noslot,   neogeo,   neogeo_state, init_neogeo,   ROT0, "Alpha Denshi Co.", "World Heroes (MGD2)", MACHINE_SUPPORTS_SAVE )

